﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="EditPromotions.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Promotion.EditPromotions" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-tags"></i>Add/Edit Promotions
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Promotions.aspx">Promotions</a></li>
                <li class="active">Add/Edit Promotions</li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 text-right col-xs-12">
            <div class="buttonpanel">
                <asp:Button ID="btnSave" runat="server" CssClass="btn btn-primary btn-lg" Text="Save" OnClientClick="return ValidateUI(); "
                    OnClick="btnSave_Click" />
                &nbsp;
                    <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-primary btn-lg loading" Text="Cancel"
                        OnClick="btnCancel_Click" />
            </div>
        </div>
    </div>

    <div class="row padTop10">
        <div class="col-md-2 col-xs-12">
            <asp:Label ID="lblMessage" runat="server" CssClass="labelerror" />
        </div>
    </div>

    <ul class="nav nav-tabs" data-tabs="tabs" id="promotiontabs">
        <li class="active"><a data-toggle="tab" href="#promogeneral">General</a></li>
        <li><a data-toggle="tab" href="#promoproducts">Products</a></li>
    </ul>

    <div class="tab-content responsive">
        <div class="col-xs-12 tab-pane active" id="promogeneral">
            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    Promotion Name
                </div>
                <div class="col-md-8 col-xs-12">
                    <asp:HiddenField ID="hdPromotionID" runat="server" />
                    <asp:TextBox ID="txtPromotionName" runat="server" CssClass="textbox required" data-error="Promotion Name" />
                </div>
            </div>

            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    Max Number Of Use
                </div>
                <div class="col-md-4 col-xs-12">
                    <asp:TextBox ID="txtMaxUsage" runat="server" data-error="Max Usage" CssClass="textbox number" MaxLength="5" Width="100px" />
                </div>
            </div>

            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    Price Range
                </div>

                <div class="col-md-4 col-xs-12 cwhite padTop10">

                    <table>
                        <tr>
                            <td>From
                                <asp:TextBox ID="txtPriceRangeFrom" runat="server" CssClass="textbox number" data-error="Price Range From" MaxLength="5" Style="min-width: 100px;" Width="100" /></td>
                            <td>To 
                                <asp:TextBox ID="txtPriceRangeTo" runat="server" CssClass="textbox number" MaxLength="5" Style="min-width: 100px;" data-error="Price Range To" Width="100" /></td>
                            <td>
                                <asp:CheckBox ID="chkUseFromPrice" runat="server" CssClass="cwhite" Text="Use From Price" /></td>
                        </tr>
                    </table>
                </div>
                <%-- <div class="col-md-8 col-xs-12 cwhite padTop10"></div>
                <div class="col-md-8 col-xs-12 cwhite padTop10"></div>
                <div class="col-md-8 col-xs-12 cwhite padTop10"></div>
                <div class="col-md-8 col-xs-12 cwhite padTop10"></div>--%>
            </div>

            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    Start Date
                </div>
                <div class="col-md-4 col-xs-12">
                    <asp:TextBox ID="txtStartDate" runat="server" CssClass="datepicker" Width="100px" />
                </div>
            </div>

            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    End Date
                </div>
                <div class="col-md-4 col-xs-12">
                    <asp:TextBox ID="txtEndDate" runat="server" CssClass="datepicker" Width="100px" />
                </div>
            </div>

            <div class="row padTop10">
                <div class="col-md-4 col-xs-12 cwhite">
                    Status
                </div>
                <div class="col-md-4 col-xs-12">
                    <asp:CheckBox ID="chkIsActive" runat="server" Text="Active" CssClass="cwhite" Checked="True" />
                </div>
            </div>
        </div>

        <div class="col-xs-12 tab-pane" id="promoproducts">
            <asp:HiddenField ID="hdPromotionDetailsID" runat="server" />
            <asp:HiddenField ID="hdProductPrice" runat="server" />

            <div class="col-xs-6">
                <div class="row padTop10">
                    <div class="col-md-4 col-xs-12 cwhite">
                        Category
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <asp:DropDownList ID="ddlCategory" runat="server" CssClass="listbox" AutoPostBack="true" OnSelectedIndexChanged="ddlCategory_SelectedIndexChanged" />
                    </div>
                </div>

                <div class="row padTop10">
                    <div class="col-md-4 col-xs-12 cwhite">
                        Brand
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <asp:DropDownList ID="ddlBrand" runat="server" CssClass="listbox" AutoPostBack="true" OnSelectedIndexChanged="ddlBrand_SelectedIndexChanged" />
                    </div>
                </div>

                <div class="row padTop10">
                    <div class="col-md-4 col-xs-12 cwhite">
                        Size
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <asp:DropDownList ID="ddlSize" runat="server" CssClass="listbox" AutoPostBack="true" OnSelectedIndexChanged="ddlSize_SelectedIndexChanged" />
                    </div>
                </div>

                <div class="row padTop10">
                    <div class="col-md-4 col-xs-12 cwhite">
                        Product
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <asp:DropDownList ID="ddlProduct" runat="server" CssClass="listbox" AutoPostBack="true" OnSelectedIndexChanged="ddlProduct_SelectedIndexChanged" />
                    </div>
                </div>
            </div>

            <div class="col-xs-6">
                <div class="row padTop10">
                    <div class="col-md-4 col-xs-12 cwhite">
                        Promotion Type
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <asp:DropDownList ID="ddlPromotionType" runat="server" CssClass="listbox discselect" Width="200px">
                            <asp:ListItem Value="0" Text="-- Please Select --" />
                            <asp:ListItem Selected="true" Value="Quantity" Text="Quantity" />
                            <%-- <asp:ListItem Value="Dollar" Text="Dollar" />
                            <asp:ListItem Value="Percentage" Text="Percentage" />--%>
                        </asp:DropDownList>
                    </div>
                </div>

                <%--<div class="row padTop10" id="discountvalue">
                    <div class="col-md-4 col-xs-12 cwhite">
                        Discount Value
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <asp:TextBox ID="txtDiscountValue" runat="server" CssClass="textbox number" MaxLength="5"
                            Width="100px" />
                    </div>
                </div>--%>

                <div class="row padTop10" id="discountqty">
                    <%--style="display: none;"--%>
                    <div class="col-md-4 col-xs-12 cwhite">
                        Quantity
                    </div>
                    <div class="col-md-8 col-xs-12">
                        <table>
                            <tr>
                                <td>Buy 
                    <asp:TextBox ID="txtBuyQty" runat="server" CssClass="textbox number" MaxLength="5"
                        Width="100px" Style="min-width: 100px !important" /></td>
                                <td>and get
                    <asp:TextBox ID="txtFreeQty" runat="server" CssClass="textbox number" MaxLength="5"
                        Width="100px" Style="min-width: 100px !important" />
                                    free</td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row padTop10">
                    <div class="col-md-4 col-xs-12 cwhite" style="float: right;">
                        <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-lg btn-primary" Text="Add"
                            OnClick="btnAdd_Click" />
                    </div>
                </div>
            </div>
            <br />
            <br />
            <div class="col-xs-12 text-center">
                <section class="tile contentField color" style="margin-top: 15px;">
                    <asp:GridView runat="server" ID="grdPromoDetails" CssClass="table" ForeColor="White"
                        Width="98%" GridLines="Both" AutoGenerateColumns="false" OnRowDataBound="grdPromoDetails_RowDataBound">
                        <Columns>
                            <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                                HeaderText="Sl. No.">
                                <ItemTemplate>
                                    <%# Container.DataItemIndex + 1  %>
                                    <asp:HiddenField ID="hdPromoDetailID" runat="server" Value='<%# Eval("UniqueID") %>' />
                                </ItemTemplate>
                                <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                                <ItemStyle HorizontalAlign="Center"></ItemStyle>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Category">
                                <ItemTemplate>
                                    <asp:Label ID="lblCategoryName" runat="server" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Brand">
                                <ItemTemplate>
                                    <asp:Label ID="lblBrandName" runat="server" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Size">
                                <ItemTemplate>
                                    <asp:Label ID="lblSizeName" runat="server" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Name">
                                <ItemTemplate>
                                    <asp:Label ID="lblProductName" runat="server" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField HeaderText="Type" DataField="PromoType" />
                            <%--<asp:BoundField HeaderText="Discount" DataField="Discount" DataFormatString="{0:0.00}" />--%>
                            <asp:BoundField HeaderText="BuyingQty" DataField="BuyingQty" />
                            <asp:BoundField HeaderText="Free Qty" DataField="DiscountQty" />
                            <asp:TemplateField HeaderText="Control">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnEditOptions" runat="server" CommandArgument="UniqueID" Text="Edit" OnClick="btnEditOptions_Click" />&nbsp;
                                <asp:LinkButton ID="btnDelete" runat="server" CommandArgument="UniqueID" Text="Delete" OnClick="btnDelete_Click" OnClientClick="return confirm('Are you sure do you want to delete?');" />
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                        <HeaderStyle CssClass="tbl-header" />
                        <RowStyle CssClass="tbl-row" />
                        <AlternatingRowStyle CssClass="tbl-row" />
                        <EmptyDataRowStyle />
                        <EmptyDataTemplate>
                            No Record found
                        </EmptyDataTemplate>
                        <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                    </asp:GridView>
                </section>
            </div>
        </div>
    </div>

    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script type="text/javascript">
        $(document).ready(function () {
            $('.discselect').change(function () {
                //ShowHidePromoType();
            });
        });

        function ShowHidePromoType() {
            //alert();
            var optionSelected = $('.discselect').find("option:selected");
            var valueSelected = optionSelected.val();
            var textSelected = optionSelected.text();
            if (valueSelected == 'Quantity') {
                $('#discountqty').show();
                $('#discountvalue').hide();
            }
            else {
                $('#discountqty').hide();
                $('#discountvalue').show();
            }
        }

        function activeTab(tab) {
            $('.nav-tabs a[href="' + tab + '"]').tab('show');
        };
    </script>
</asp:Content>
